# Editorial Workflow

1. Introduction
2. [Managing Submission Details](editorial-workflow.md#manage-submission-details)
3. [Editorial Actions](editorial-workflow.md#editorial-actions)
4. [Participants](editorial-workflow.md#participants)

The editorial workflow allows you to usher a submission from initial evaluation through peer review, copyediting and production, where the item is prepared for publication.

Each tab on the workflow page provides you with the information, tools and discussion panels you'll need to complete the tasks for that stage. You can [add participants](editorial-workflow.md#participants) to help you. And when your ready, you'll be presented with a range of [editorial actions](editorial-workflow.md#editorial-actions) appropriate to each stage.

## <a name="manage-submission-details"></a>Managing Submission Details

Submission details appear at the top of the page. In this area, you'll also find tools to help you manage the submission's metadata and editorial history. The data attached to the submission from these tools persists across all stages.

### <a name="metadata"></a>Metadata

The Metadata section includes two tabs: Submission and Identifiers.

Submission includes the submission metadata, such as article title, abstract, contributors, and keywords.

Identifies provides a space to add any public URL identifiers.

### <a name="editorial-history"></a>History

Add notes for record-keeping and view a log of all events associated with this submission. Only editorial and administrative staff have access to the Editorial History.

### <a name="submission-library"></a>Submission Library

A quick-access repository for any files that you'd like to track along with the submission. This is useful for files that aren't specific to any stage, such as signed contracts, marketing files, or guidelines you'd like to share with copyeditors or other assistants.

You can quickly add files from your [Publisher Library](settings.md#workflow-library) by clicking on **View Document Library**.

## <a name="editorial-actions"></a> Editorial Actions

At the top right of each stage of the workflow, you'll see the editorial actions available to you. These decisions change with each stage. But in most cases, they complete the current stage and forward the submission onto the next stage.

Read the help guide for each stage to learn more about the editorial actions.

## <a name="participants"></a>Participants

On the right of each stage of the workflow, you'll find a list of users who have access to this stage. You can add editorial assistants, copyeditors, layout editors or other users you'd like to have access to the current stage.

*When you add a user, that user will have access to any stages allowed by their user role*. For example, an Editor added to the Participants grid will have access to every stage. But a Copyeditor will only have access to the Copyediting stage.

*You won't need to add Reviewers to the Participants panel.* Once you get to the [review stages](editorial-workflow/review.md), you'll be able to manage the reviewers in a more convenient panel.
